<?php

class FormInquiriesApi
{
	protected function getBuilderRequestData(FormNavigation $request, $actionId, $signatureFields = array())
	{
		header('Access-Control-Allow-Origin: *', true); // allow cross domain requests

		$data = $request->getBodyAsJson();
		if (!$data || !is_object($data) || !isset($data->sig)) {
			FormModule::respondWithJson(array(
				"error" => array("code" => 1, "message" => "Bad request")
			));
		}

		$sigCheckStr = FormModule::$siteInfo->websiteUID . "|" . $actionId;
		foreach ($signatureFields as $k)
			$sigCheckStr .= "|" . $k . "=" . $data->{$k};

		$expectedHash = md5($sigCheckStr);
		$hash = $this->publicDecrypt($data->sig);
		if ($hash !== $expectedHash) {
			FormModule::respondWithJson(array(
				"error" => array("code" => 2, "message" => "Bad signature")
			));
		}

		return $data;
	}

	public static function process(FormNavigation $request, $homePage = false) {
		if ($homePage) {
			$ctrl = new self();
			$key = $request->getArg(0) ?: '';
			$action = array_map('ucfirst', explode('-', strtolower(preg_replace('#[^a-zA-Z0-9\-]+#', '', $key))));
			$action[0] = strtolower($action[0]);
			$method = implode('', $action).'Action';
			if (method_exists($ctrl, $method)) {
				call_user_func(array($ctrl, $method), $request);
			}
		}
		return null;
	}

	protected function formsLogAction(FormNavigation $request)
	{
		$data = $this->getBuilderRequestData($request, 'forms-log');

		if (isset($data->formUuid) && $data->formUuid) {
			$formId = $data->formUuid;

			$list = FormModuleInquiries::findByFormId($formId);
			foreach ($list as $idx => $li) {
				$list[$idx] = $li->jsonSerialize();
			}

			FormModule::respondWithJson(array("ok" => true, "list" => $list));
		} else {
			FormModule::respondWithJson(array("error" => array("code" => 1, "message" => "Bad request")));
		}
	}

	protected function removeInquiryAction(FormNavigation $request)
	{
		$data = $this->getBuilderRequestData($request, 'remove-inquiry', array("id"));

		$inquiry = FormModuleInquiries::findById($data->id);
		if ($inquiry) {
			$inquiry->delete();
		}

		FormModule::respondWithJson(array("ok" => true));
	}

	private function publicDecrypt($encData)
	{
		require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
		require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
		require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
		require_once __DIR__ . '/../../phpseclib/Crypt/RSA.php';
		$rsa = new \phpseclib\Crypt\RSA();
		$rsa->loadKey($this->getSecurityPublicKey());
		$rsa->setEncryptionMode(\phpseclib\Crypt\RSA::ENCRYPTION_PKCS1);
		$data = @$rsa->decrypt(base64_decode($encData));
		return ($data === false) ? null : $data;
	}

	private function publicEncrypt($data)
	{
		require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
		require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
		require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
		require_once __DIR__ . '/../../phpseclib/Crypt/RSA.php';
		$rsa = new \phpseclib\Crypt\RSA();
		$rsa->loadKey($this->getSecurityPublicKey());
		$rsa->setEncryptionMode(\phpseclib\Crypt\RSA::ENCRYPTION_PKCS1);
		$encData = @$rsa->encrypt($data);
		return ($encData === false) ? null : base64_encode($encData);
	}

	private function getSecurityPublicKey()
	{
		return "-----BEGIN PUBLIC KEY-----\n"
			. "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzeio9jpU3e31Rlc4w0SA\n"
			. "jOWOkjS++yZnyaziUDyLXupLxELER2SHyA2nFG7eOuKPohYFomX/GQdtbMLLL+4J\n"
			. "/IofyOi1t/jlafY3wzTYCN2u8pfYP6L5sChuE3zb+g7Gvq/1XewiroDChy0mE+zr\n"
			. "mATJp+UY2zcc60S0aiv+mFaGHrD6vyK/uUlfd2XbLNjWJnOe4HKq/uZb9MK8yY34\n"
			. "snpLzrwmnxjS0/UDvljdrUAA1gIYA8rIO08AiyT9evTQEMyp4861COfGVdASHi/i\n"
			. "O5piPRMp1BuY0LYk0ykA79gI7kygk5qQRcHJLZ1jhsm4jHl7chrjJ3jis8Pk4ico\n"
			. "KwIDAQAB\n"
			. "-----END PUBLIC KEY-----\n";
	}

}
